## Modifying schemas


This section describes how a schema in a live application can be modified—categories:

  [
    Valid changes without restart or re-feed](https://docs.vespa.ai/en/reference/schema-reference.html#valid-changes-without-restart-or-re-feed)
  [
    Changes that require restart but not re-feed](https://docs.vespa.ai/en/reference/schema-reference.html#changes-that-require-restart-but-not-re-feed)
  [
    Changes that require reindexing](https://docs.vespa.ai/en/reference/schema-reference.html#changes-that-require-reindexing)
  [
    Changes that require re-feed](https://docs.vespa.ai/en/reference/schema-reference.html#changes-that-require-re-feed)


When running `vespa prepare` on a new application package,
the changes in the schema files are compared with the files in the current active package.
If some of the changes require restart or re-feed, the output from `vespa prepare`
specifies which actions are needed.


> *IMPORTANT:* 
> For changes that are not covered below,
> and no output is returned from `vespa prepare`,
> the impact is undefined and in no way guaranteed to allow a system to stay live until re-feeding.
> Changes not related to the schema are discussed
> in [admin procedures](https://docs.vespa.ai/en/operations-selfhosted/admin-procedures.html).




[Read more](https://docs.vespa.ai/en/reference/schema-reference.html#modifying-schemas)